#ifndef DEBUG_LOGGER_H
#define DEBUG_LOGGER_H

#include "FunctionLogger.h"
#include <fstream>

using namespace std;

class CDebugLogger
{
private:
  int m_nIndent;
  ofstream m_logFile;
  bool m_bIndentWritten;

  char IndentChar;

public:
  CDebugLogger();
  virtual ~CDebugLogger();

  void StartDebugLogging( char* strFileName_p );
  void StopDebugLogging();

private:
  void WriteDecUInt( unsigned int uVal_p );
  void WriteHexUInt( unsigned int uVal_p );

  void Write( const char* strMessage_p );
  void WriteLine( const char* strMessage_p );
  void WriteLineBreak();

  void WriteIndentChars();

  void IncrementIndent();
  void DecrementIndent();

  friend class CFunctionLogger;
};

#endif